#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Water VFXMod01.fsh   by   rge15 
//https://www.shadertoy.com/view/NljfRd
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265358979


float N21(in vec2 p)
{
    p = 50.*fract((p + vec2(7.3945,0.2594273))/PI);
    return -1.+2.*fract( p.x*p.y/(p.x+p.y) );
}

vec2 N22(in vec2 p)
{
    p = 50.*fract((p+vec2(0.24342,709.23))/PI);
    return 1. - 2.*fract(p * vec2(p.x+p.y, p.y*p.x) + vec2(0.29137,0.9348));
}

float valueNoise(in vec2 uv)
{
    vec2 i = floor(uv);
    vec2 f = fract(uv);

    vec2 func = f*f*(3.-2.*f);

    float a = N21(i+vec2(0.,0.));
    float b = N21(i+vec2(1.,0.)); 
    float c = N21(i+vec2(0.,1.)); 
    float d = N21(i+vec2(1.,1.)); 
    
    return a + (b-a)*func.x + (c-a)*func.y + (a-b-c+d)*func.x *func.y;

}

float gradientNoise(in vec2 uv)
{

    vec2 i = floor(uv);
    vec2 f = fract(uv);

    vec2 func = f*f*(3.-2.*f);

    vec2 a = N22(i+vec2(0.,0.));
    vec2 b = N22(i+vec2(1.,0.)); 
    vec2 c = N22(i+vec2(0.,1.)); 
    vec2 d = N22(i+vec2(1.,1.)); 
    
    float gA = dot(a,f-vec2(0.,0.));
    float gB = dot(b,f-vec2(1.,0.));
    float gC = dot(c,f-vec2(0.,1.));
    float gD = dot(d,f-vec2(1.,1.));
    
    return gA + (gB-gA)*func.x + (gC-gA)*func.y + (gA-gB-gC+gD)*func.x *func.y;

}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (2.*fragCoord-iResolution.xy)/iResolution.y;


    float p = 0.7 + 0.15 * valueNoise(4.*uv);

    float b = 0.5 + gradientNoise(10.*uv) ;

    float c = 0.2 + .75*gradientNoise(2.*uv);
    float t = smoothstep( 0.1,1. , c + gradientNoise(3.5*uv-0.7*iTime));
    
    vec3 w = p * vec3(0.05,0.75,0.9) + (p*t) * vec3(1.,1.,1.);

    // Output to screen
    fragColor = vec4(vec3(w),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

